export const BusinessIcon = () => (
    <svg width="72" height="73" viewBox="0 0 72 73" fill="none" xmlns="http://www.w3.org/2000/svg"
         xmlns="http://www.w3.org/1999/xlink">
        <rect y="0.705078" width="72" height="72" rx="10" fill="var(--cgds-primary-gray)"/>
        <mask id="mask0_415_7575" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="4" y="4" width="64" height="65">
            <rect width="64" height="64" transform="translate(4 4.70508)" fill="url(#pattern0_415_7575)"/>
        </mask>
        <g mask="url(#mask0_415_7575)">
            <rect x="-13" y="-3.29492" width="89" height="81" fill="var(--cgds-primary)"/>
        </g>
        <defs>
            <pattern id="pattern0_415_7575" patternContentUnits="objectBoundingBox" width="1" height="1">
                <use href="#image0_415_7575" transform="scale(0.00666667)"/>
            </pattern>
            <image id="image0_415_7575" width="150" height="150"
                   href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJYAAACWCAQAAACWCLlpAAAABGdBTUEAALGPC/xhBQAAAAJiS0dEAP+Hj8y/AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5gMdAQYAvoJqHAAAA5hJREFUeNrt3D1rU2EYxvHrJKYtRimCgkeUiqBIg5MEpLMUQVzEj9DBoeimIn6DjiIVF5eOujlIQDcR3JRWMPiCSogiUYmoSZs2DmKItCTPlfuQu4dcv6kpOU+f/Js85+TtRG1IqIz3BNJEsQiKRVAsgmIRFIugWATFIigWQbEIikVQLIJiERSLoFgExSIoFkGxCIpFUCyCYhEUi6BYBMUiKBZBsQiKRVAsgmIRFIugWATFIigWQbEIikVQLIJiERSLoFgExSIoFmGHdYDqoBtOIsYY2C94RGiggp/hG8TWG9jFHGtAM7iIkxgfINYvPMEiXnhMOrJ+d2ege9ZZLOKQ4Y++xByehl01yXuWx5q1HzdMqYBpXMXu4U/cI1YRJ8xjnEJh+BP3iBVjwjxGHnuGP3GPBT7679JnvNr0u83ayOA49nZdduC1N/znC+bxqG8qAIhwDjexy3Oy3rHeo4R64HUfo+Yby/sIfoP4d+Wc5+oSK4ds5+c8MYMs8l3bZYO3S4zHw7CMe8iiDSCDMprB29VxH/sA/D2Orwx/4h5H8LnOAyrCOprBe7YIE51dQRurWA/ZKO3PDdewNtB2bfx2mG0X7wU+VZK6Z2VwFFO+O/atVet4i3dxIgexycSaxhWcxqTHHqqvFmp4UF2IP9iHSmKBL+Auit5N+ihhLv5oHcS+Zu3EtW2fCpjFfHXMOog9VgFnvEsEOY/D1iHssaa6XgvYzg7goHUIe6xx7wqBIvvOzB4rPSfgMs9UB6UExSIoFkGxCKMTK+R1/j7ssdKSe8w+U/sT6TLuYPsfQERowvxU2uezDkOU9s86pJZiEexrVsb9jdqeupaJVrxhG8t+Q2dwGe0ULPCrWMBz2yD2WEdwwbtEoCVrLPua1fJuEKgR9j5jL6OzwCewUIxOrAQoFkGxCIpFUCyCYhEUi6BYBMUiKBZBsQiKRVAsgmIRFIugWATFIigWQbEIikVQLIJiERSLoFgExSIoFkGxCIpFsMeqoeF9I4L8wDfrEPZYy1j27hDkGV5bh7DHquA2cSILL19xK/5uHSSJNWsJ1/HJu0ZPb3AJJfswSX0OvohZHPM/tc4WGljBw3gliaHMsUaJDh0IikVQLIJiERSLoFgExSIoFkGxCIpFUCyCYhEUi6BYBMUiKBZBsQiKRVAsgmIRFIugWATFIigWQbEIikVQLIJiERSLoFgExSIoFkGxCIpFUCyCYhH+APdpdPS5kvvXAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDIyLTAzLTI5VDAxOjA2OjAwKzAwOjAwWFUeAAAAACV0RVh0ZGF0ZTptb2RpZnkAMjAyMi0wMy0yOVQwMTowNjowMCswMDowMCkIprwAAAAASUVORK5CYII="/>
        </defs>
    </svg>
);

export const NewsIcon = () => (
    <svg width="72" height="73" viewBox="0 0 72 73" fill="none" xmlns="http://www.w3.org/2000/svg"
         xmlns="http://www.w3.org/1999/xlink">
        <rect y="0.705078" width="72" height="72" rx="10" fill="var(--cgds-primary-gray)"/>
        <mask id="mask0_418_8641" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="4" y="4" width="64" height="65">
            <rect width="64" height="64" transform="translate(4 4.70508)" fill="url(#pattern0_418_8641)"/>
        </mask>
        <g mask="url(#mask0_418_8641)">
            <rect x="-17" y="-12.2949" width="98" height="106" fill="var(--cgds-primary)"/>
        </g>
        <defs>
            <pattern id="pattern0_418_8641" patternContentUnits="objectBoundingBox" width="1" height="1">
                <use href="#image0_418_8641" transform="scale(0.00666667)"/>
            </pattern>
            <image id="image0_418_8641" width="150" height="150"
                   href="data:image/png;base64,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"/>
        </defs>
    </svg>
);

export const FamilyIcon = () => (
    <svg width="73" height="73" viewBox="0 0 73 73" fill="none" xmlns="http://www.w3.org/2000/svg"
         xmlns="http://www.w3.org/1999/xlink">
        <rect x="0.115234" y="0.705078" width="72" height="72" rx="10" fill="var(--cgds-primary-gray)"/>
        <mask id="mask0_418_8605" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="4" y="4" width="65" height="65">
            <rect x="4.11523" y="4.70508" width="64" height="64" rx="10" fill="url(#pattern0_418_8605)"/>
        </mask>
        <g mask="url(#mask0_418_8605)">
            <rect x="-52.8848" y="-14.2949" width="128" height="128" rx="10" fill="var(--cgds-primary)"/>
        </g>
        <defs>
            <pattern id="pattern0_418_8605" patternContentUnits="objectBoundingBox" width="1" height="1">
                <use href="#image0_418_8605" transform="scale(0.00666667)"/>
            </pattern>
            <image id="image0_418_8605" width="150" height="150"
                   href="data:image/png;base64,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"/>
        </defs>
    </svg>
);

export const OrganizationIcon = () => (
    <svg width="72" height="73" viewBox="0 0 72 73" fill="none" xmlns="http://www.w3.org/2000/svg"
         xmlns="http://www.w3.org/1999/xlink">
        <rect y="0.705078" width="72" height="72" rx="10" fill="var(--cgds-primary-gray)"/>
        <mask id="mask0_418_8632" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="4" y="4" width="64" height="65">
            <rect width="64" height="64" transform="translate(4 4.70508)" fill="url(#pattern0_418_8632)"/>
        </mask>
        <g mask="url(#mask0_418_8632)">
            <rect x="-8" y="-5.29492" width="82" height="74" fill="var(--cgds-primary)"/>
        </g>
        <defs>
            <pattern id="pattern0_418_8632" patternContentUnits="objectBoundingBox" width="1" height="1">
                <use href="#image0_418_8632" transform="scale(0.00666667)"/>
            </pattern>
            <image id="image0_418_8632" width="150" height="150"
                   href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJYAAACWCAQAAACWCLlpAAAABGdBTUEAALGPC/xhBQAAAAJiS0dEAP+Hj8y/AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5gMdAQYDJ4s7pgAABOdJREFUeNrtnEtoHVUch7+5t7l51NS0TVJLXRRCDZXWB1gQfIQgIoiitqAgbhRcBbVQceFCXIgLqaDSrkRX1oALdeFGSgiJWqTdGBVEbXFjbdqktLF53Wtzx4VB40wS5zf3xEnh960u8/jfc76Zc+ece85/ohiTlVLRBbiWsCwByxKwLAHLErAsAcsSsCwByxKwLAHLErAsAcsSsCwByxKwLAHLErAsAcsSsCwByxKwLAHLErAsAcsSsCwByxLYkP3Qc2vx/SXpctWphy/C9sxHCrKCU+FO+ugWzrjACF9TK6rAxclqYYCX6CISzomZ4A2OMl9MkaPsS46CNsOIR3mfjhxnXuYZPiXgSqnszbCoH/gK+3Opgg72Uymm0EXJKrMj97k7KBdTaHcdBCxLwLIELEvAsgQsS8CyBCxLwLIELEvAsgQsS8CyBCxLwLIELEvAsgQsS8CyBCxLwLIEipIVM5f73LmQs4YKRcmqMcrVXGdeZbSoCfyiZC0wyHCOZR51hhlkoZhCFzV9DxE9PM+9tCS2t3AjZWCBX1NrGuYZ5R3OhG2G2afvi5MFUKGT5sS23XzAZuAST/FDYl+VyfBN8NpYcgQ1fktt27TYOOuc5ZdCS5fCXQcByxKwLAHLErAsgXBPw0haHbpanH8+hbmUcah+WRhZJfbQT2uQWNsX47TydKCu3RzDfB9iUXiYTuluPuTWQHdWeGLGeDLVwf2b/3sB7l56160qiOhlb4hAYWSV17EqgCjMkt2ww53zDPFHgzE28wDNQJXPudRgrCbuY1u46oWV9TMH+b3BGLdwF83ANK/xbYOxNvHx+pUVU6XaYIzakk+NxqqG/TPHnVIByxKwLAHLErAsgTxPw7TgaMm+5N7Vh7Hp4fdqA2k1VmmVWOijRVVWO33sS+X73bwYZyevpB735zjOj8sWrMI+7uH6xNZu2gBo4zkuJPZN8QWnlp2yKNHL/alhXjM7F2v5RGrAU+MUI1xRKq8NpG/gdR5no6S3zhle5LOUrlZe4BCdUiyY5E3eTs1ml3iIw/SIPyozfMTLjGcfSJdfzXzodBOHGEjN8/0XEVu5neNcTGx9kMNsEWNBG3fwHT8ltt7EezmG8hX2MMtX7Zmbo3ItuniYJrl6ALvoT1SlwoHcab8HEj8DEf3syhWriUeU7H9F1hbptQJLKaeaSMi03xI9uf9V6FbubkWW9sKKf9O0ylNPJR0p3/0u18n9LAHLErAsAcsSsCwByxKwLAHLErAsAcsSsCwByxKwLAHLErAsAcsSsCwByxKwLAHLElBkzTKT+3smE5OscQPvR55PTOLXmcwda4bZ7AcrssYZy7mSboqTCVk1RnPmoy6k0n7rnGQqV6yYMcbXRtYMRzidQ1eNY5xIVXmQoVxpv0PLpP2e4FiOpM2Y0xxRWou21qHM3Qxwm/Ai6JgJPuHdZRpKRA8H6aNdqN4VRnhr2bTfTp7lMemF6TW+4ShfsrCWab8b2ZZK1V2ZOpe5uGKefTNdXJe5gjHTTKy4KHcDW+kQWkqV83/dVWsiy7jrIGBZApYlYFkCliVgWQKWJWBZApYlYFkCliVgWQKWJWBZApYlYFkCliVgWQKWJWBZApYlYFkCliVgWQKWJWBZApYlYFkCliVgWQKWJWBZApYlYFkCliVgWQKWJWBZAn8CrRPeeI5BZT8AAAAldEVYdGRhdGU6Y3JlYXRlADIwMjItMDMtMjlUMDE6MDY6MDMrMDA6MDBpvQSdAAAAJXRFWHRkYXRlOm1vZGlmeQAyMDIyLTAzLTI5VDAxOjA2OjAzKzAwOjAwGOC8IQAAAABJRU5ErkJggg=="/>
        </defs>
    </svg>
)

export const CameraIcon = () => (
    <svg width="72" height="73" viewBox="0 0 72 73" fill="none" xmlns="http://www.w3.org/2000/svg"
         xmlns="http://www.w3.org/1999/xlink">
        <rect y="0.705078" width="72" height="72" rx="10" fill="var(--cgds-primary-gray)"/>
        <mask id="mask0_418_8623" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="4" y="4" width="64" height="65">
            <rect width="64" height="64" transform="translate(4 4.70508)" fill="url(#pattern0_418_8623)"/>
        </mask>
        <g mask="url(#mask0_418_8623)">
            <rect x="-5" y="-9.29492" width="73" height="78" fill="var(--cgds-primary)"/>
        </g>
        <defs>
            <pattern id="pattern0_418_8623" patternContentUnits="objectBoundingBox" width="1" height="1">
                <use href="#image0_418_8623" transform="scale(0.00666667)"/>
            </pattern>
            <image id="image0_418_8623" width="150" height="150"
                   href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJYAAACWCAQAAACWCLlpAAAABGdBTUEAALGPC/xhBQAAAAJiS0dEAP+Hj8y/AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5gMdAQYFzuiekwAABhxJREFUeNrtnFtsVEUYgL/TpZRabgZk2wYo95J6QRsqQgRDxFt9AB8E+oBREolEX4hgosQIRjEkWjAxEo1ACHhpjAEJiYqBGkUMJFwqaDEFpagtFaGUFCws3fWhiJxZtj3/cZnZ4v+9zd8zu//5umfOzJyZ4yVQgpLlOoHuhMoSoLIEqCwBKkuAyhKgsgSoLAEqS4DKEqCyBKgsASpLgMoSoLIEqCwBKkuAyhKgsgSoLAEqS4DKEqCyBKgsASpLgMoSoLIEqCwBKkuAyhKgsgSoLAEqS4DKEqCyBKgsASpLgMoSoLIE9AhTqTHVHwYxhpwAH5DFaWppdXniBSHqhJKVgjwquI8cut6HkMVpNrCZuDU3aSGdsh5hCf0DH30zhzno+vRlpLPNKhWoguEUuz55KemUFREdHU/rr9oKejcUoLIEqCwBLmV1u62O4RvZCL2uKMW5KPwsj170Et4U0kMb7eEqemH+vY0eE3iaIt+XxhnDYMGHxDlEE55FSR1EOMZb7CoIceLhZBVSxd3WTzN97GBWQYO8Wrg2K58S1+f7nyghP0y1cLK87tc4+0iEu/y16yBAZQlQWQJUlgCVJUBlCcisOaUTHKORZtqBngygkKH0c53Uv2SKrCa+ZicHOMqfnCMBRMgjykhuZwqTyHOdIGSGrEY+YiPf0+KLXuQ8p6hlC1EmMJPp9HadqGtZMTaxkj2c7+SYJjaznY95lsluk3XbwP/BizzJzk5VddDKp8xhFX+5TNflL+soi/lQMMqsZxENLKKvq4TdyapnIZ8I65xlOTEW08dNyq4uw2ae70RVVsq8YlSygotuknbzy0qwgqqrxHtSSinD6Qec4Sh72JvUnsWoZDQVLtJ2I2sr7yatc4jwAI9xFwX0vKylgd2s43NjzryF1yljlP20XVyGLbxDkxGLsow1zKLosirIpohHWc1rRI2j97HaQd5OZH3JNiMymEoWJCnpIMoC3mSIL5ZgIzX2E7cvq5VNnPFF8lhCBdkpa/RgJkuN/vtPbLE/tW1f1g98Y0SeoKKLOXGP2cw1YttTr6m7VtiXtZdffeVRzOWGLmvlMtdo0vdTazt127La2G9cPg9yW6Cat1DuK5/iR8u5W5fVTJ2vnMvEgI/wI0kTNXUBxpRpxbasFo77ygWC9X/FxqrZ320Pq23LOkezr3xjig7D1RhoLMM8fb3LShg994hgDJFtdC/abXcebMvyjG9sJxa4bowLRu6W1+DYlpVjNNLNnAhc94Qx8dzniqGRFWzL6sNNvnKDoLdUy2++cqHtxxi2ZfVnpK/cxo6AF2KMb2nzRUYH2vqSRuz/sswu6Fb2Bqq5jy985b4UX+9tlscdDPBFfmZNgC1PrazliC9SYn9Bnf2x4TjKjMgHrO9iy1OC91lvxCYz1Hbq9mUN4mFjgNPKUtZ2oivOOl7mrC+WT7n9lc4uJv9mMN6INPEcr3D1JbGNLGNh0t8eYpL9xF3MwQ9mHgc454udYglfMZt7GXFFs32EbVRRndRTL2K+7T6WK1lQQTUbjFiCar6jmGKGMxA4ST21HDK6CwC5PJPU7lnBjaxcFlPHrqR4GzXU4JENxFKM/LKYxTwnWTt7yDqW5Skn/RJc4ELKQXI5L7l6gO9uYcg9rGScsI7HdN5gmKuUXa6imcp73C84Po/5vM0Ydwm7XXI0nnW8EHB71K2soJJCl+m6XsyWz6tMYwOfdfpgaywzmON+v5BrWQBTKeNxtlPNQU4a2RVQyjSmUJIJmWZACkBvJjOJp6jnF+pppA3oSyHDGMEQ0QsQrimZIQsgQpQod5K4tGbGsz9t3BWZI+sfvAzM6RK6w0KAyhKgsgSoLAEqS0A4WfFMu6kL8cK95iycrOMuVnSmkRpjLU9Awr0EAyYyj2h3ew0dAFk0sYrdYd75F1ZWDqMY0C3f7uBxksOctybr/4reDQWoLAEqS4DKEqCyBKgsASpLgMoSoLIEqCwBKkuAyhKgsgSoLAEqS4DKEqCyBKgsASpLgMoSoLIEqCwBKkuAyhKgsgSoLAEqS4DKEqCyBKgsASpLgMoSoLIEqCwBKkuAyhKgsgSoLAEqS8DfSsUcq5kAKYMAAAAldEVYdGRhdGU6Y3JlYXRlADIwMjItMDMtMjlUMDE6MDY6MDUrMDA6MDAKbTGnAAAAJXRFWHRkYXRlOm1vZGlmeQAyMDIyLTAzLTI5VDAxOjA2OjA1KzAwOjAwezCJGwAAAABJRU5ErkJggg=="/>
        </defs>
    </svg>
)

export const TimeIcon = ({ color = "white" }) => (
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            d="M10.475 11.525L11.525 10.475L8.75 7.7V4.25H7.25V8.3L10.475 11.525ZM8 15.5C6.9625 15.5 5.9875 15.3031 5.075 14.9094C4.1625 14.5156 3.36875 13.9813 2.69375 13.3063C2.01875 12.6313 1.48438 11.8375 1.09063 10.925C0.696875 10.0125 0.5 9.0375 0.5 8C0.5 6.9625 0.696875 5.9875 1.09063 5.075C1.48438 4.1625 2.01875 3.36875 2.69375 2.69375C3.36875 2.01875 4.1625 1.48438 5.075 1.09063C5.9875 0.696875 6.9625 0.5 8 0.5C9.0375 0.5 10.0125 0.696875 10.925 1.09063C11.8375 1.48438 12.6313 2.01875 13.3063 2.69375C13.9813 3.36875 14.5156 4.1625 14.9094 5.075C15.3031 5.9875 15.5 6.9625 15.5 8C15.5 9.0375 15.3031 10.0125 14.9094 10.925C14.5156 11.8375 13.9813 12.6313 13.3063 13.3063C12.6313 13.9813 11.8375 14.5156 10.925 14.9094C10.0125 15.3031 9.0375 15.5 8 15.5ZM8 14C9.6625 14 11.0781 13.4156 12.2469 12.2469C13.4156 11.0781 14 9.6625 14 8C14 6.3375 13.4156 4.92188 12.2469 3.75313C11.0781 2.58438 9.6625 2 8 2C6.3375 2 4.92188 2.58438 3.75313 3.75313C2.58438 4.92188 2 6.3375 2 8C2 9.6625 2.58438 11.0781 3.75313 12.2469C4.92188 13.4156 6.3375 14 8 14Z"
            fill={color}/>
    </svg>
);

export const PersonIcon = ({ color = "white" }) => (
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
            d="M9 9C8.175 9 7.46875 8.70625 6.88125 8.11875C6.29375 7.53125 6 6.825 6 6C6 5.175 6.29375 4.46875 6.88125 3.88125C7.46875 3.29375 8.175 3 9 3C9.825 3 10.5313 3.29375 11.1188 3.88125C11.7063 4.46875 12 5.175 12 6C12 6.825 11.7063 7.53125 11.1188 8.11875C10.5313 8.70625 9.825 9 9 9ZM3 15V12.9C3 12.475 3.10938 12.0844 3.32812 11.7281C3.54688 11.3719 3.8375 11.1 4.2 10.9125C4.975 10.525 5.7625 10.2344 6.5625 10.0406C7.3625 9.84688 8.175 9.75 9 9.75C9.825 9.75 10.6375 9.84688 11.4375 10.0406C12.2375 10.2344 13.025 10.525 13.8 10.9125C14.1625 11.1 14.4531 11.3719 14.6719 11.7281C14.8906 12.0844 15 12.475 15 12.9V15H3ZM4.5 13.5H13.5V12.9C13.5 12.7625 13.4656 12.6375 13.3969 12.525C13.3281 12.4125 13.2375 12.325 13.125 12.2625C12.45 11.925 11.7688 11.6719 11.0813 11.5031C10.3938 11.3344 9.7 11.25 9 11.25C8.3 11.25 7.60625 11.3344 6.91875 11.5031C6.23125 11.6719 5.55 11.925 4.875 12.2625C4.7625 12.325 4.67188 12.4125 4.60313 12.525C4.53438 12.6375 4.5 12.7625 4.5 12.9V13.5ZM9 7.5C9.4125 7.5 9.76563 7.35313 10.0594 7.05938C10.3531 6.76563 10.5 6.4125 10.5 6C10.5 5.5875 10.3531 5.23438 10.0594 4.94063C9.76563 4.64688 9.4125 4.5 9 4.5C8.5875 4.5 8.23438 4.64688 7.94063 4.94063C7.64688 5.23438 7.5 5.5875 7.5 6C7.5 6.4125 7.64688 6.76563 7.94063 7.05938C8.23438 7.35313 8.5875 7.5 9 7.5Z"
            fill={color}/>
    </svg>
);


export const ChevronRight = ({ className, ariaHidden }) => (
    <svg
        className={className}
        width="58"
        height="48"
        viewBox="0 0 58 48"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        aria-hidden={ariaHidden}
    >
        <g filter="url(#filter0_d_254_2592)">
            <rect x="5" width="48" height="48" rx="10" fill="var(--cgds-900)" />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M24.3557 15.2034C24.42 15.1389 24.4964 15.0878 24.5805 15.0529C24.6646 15.018 24.7548 15 24.8458 15C24.9369 15 25.027 15.018 25.1111 15.0529C25.1952 15.0878 25.2716 15.1389 25.3359 15.2034L33.6426 23.5101C33.7071 23.5744 33.7582 23.6508 33.7931 23.7349C33.828 23.819 33.846 23.9091 33.846 24.0002C33.846 24.0912 33.828 24.1814 33.7931 24.2655C33.7582 24.3496 33.7071 24.426 33.6426 24.4903L25.3359 32.797C25.2059 32.927 25.0296 33 24.8458 33C24.662 33 24.4857 32.927 24.3557 32.797C24.2257 32.667 24.1527 32.4907 24.1527 32.3069C24.1527 32.1231 24.2257 31.9468 24.3557 31.8168L32.1737 24.0002L24.3557 16.1836C24.2912 16.1193 24.2401 16.0429 24.2052 15.9588C24.1703 15.8747 24.1523 15.7845 24.1523 15.6935C24.1523 15.6024 24.1703 15.5123 24.2052 15.4282C24.2401 15.3441 24.2912 15.2677 24.3557 15.2034Z"
                fill="white"
            />
        </g>
        <defs>
            <filter
                id="filter0_d_254_2592"
                x="0"
                y="-1"
                width="58"
                height="58"
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity="0" result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feMorphology radius="1" operator="erode" in="SourceAlpha" result="effect1_dropShadow_254_2592" />
                <feOffset dy="4" />
                <feGaussianBlur stdDeviation="3" />
                <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0" />
                <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_254_2592" />
                <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_254_2592" result="shape" />
            </filter>
        </defs>
    </svg>
);